/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ars_nouveau.facet.range;

import java.util.Arrays;
import java.util.Comparator;
import org.apache.lucene.ars_nouveau.facet.range.ExclusiveLongRangeCounter;
import org.apache.lucene.ars_nouveau.facet.range.LongRange;
import org.apache.lucene.ars_nouveau.facet.range.OverlappingLongRangeCounter;

abstract class LongRangeCounter {
    private final int[] countBuffer;
    protected int multiValuedDocLastSeenElementaryInterval;

    static LongRangeCounter create(LongRange[] ranges, int[] countBuffer) {
        if (LongRangeCounter.hasOverlappingRanges(ranges)) {
            return new OverlappingLongRangeCounter(ranges, countBuffer);
        }
        return new ExclusiveLongRangeCounter(ranges, countBuffer);
    }

    protected LongRangeCounter(int[] countBuffer) {
        this.countBuffer = countBuffer;
    }

    void startMultiValuedDoc() {
        this.multiValuedDocLastSeenElementaryInterval = -1;
    }

    abstract boolean endMultiValuedDoc();

    void addSingleValued(long v) {
        int mid;
        long[] boundaries = this.boundaries();
        int lo = 0;
        int hi = boundaries.length - 1;
        while (true) {
            if (v <= boundaries[mid = lo + hi >>> 1]) {
                if (mid == 0) {
                    this.processSingleValuedHit(mid);
                    return;
                }
                hi = mid - 1;
                continue;
            }
            if (v <= boundaries[mid + 1]) break;
            lo = mid + 1;
        }
        this.processSingleValuedHit(mid + 1);
    }

    void addMultiValued(long v) {
        int mid;
        if (this.rangeCount() == 0) {
            return;
        }
        long[] boundaries = this.boundaries();
        if (this.multiValuedDocLastSeenElementaryInterval != -1 && v <= boundaries[this.multiValuedDocLastSeenElementaryInterval]) {
            return;
        }
        int nextCandidateElementaryInterval = this.multiValuedDocLastSeenElementaryInterval + 1;
        if (nextCandidateElementaryInterval == boundaries.length) {
            return;
        }
        int lo = nextCandidateElementaryInterval;
        int hi = boundaries.length - 1;
        while (true) {
            if (v <= boundaries[mid = lo + hi >>> 1]) {
                if (mid == nextCandidateElementaryInterval) {
                    this.processMultiValuedHit(mid);
                    this.multiValuedDocLastSeenElementaryInterval = mid;
                    return;
                }
                hi = mid - 1;
                continue;
            }
            if (v <= boundaries[mid + 1]) break;
            lo = mid + 1;
        }
        int idx = mid + 1;
        this.processMultiValuedHit(idx);
        this.multiValuedDocLastSeenElementaryInterval = idx;
    }

    abstract int finish();

    protected abstract long[] boundaries();

    protected abstract void processSingleValuedHit(int var1);

    protected abstract void processMultiValuedHit(int var1);

    protected final void increment(int rangeNum) {
        int n = rangeNum;
        this.countBuffer[n] = this.countBuffer[n] + 1;
    }

    protected final void increment(int rangeNum, int count) {
        int n = rangeNum;
        this.countBuffer[n] = this.countBuffer[n] + count;
    }

    protected final int rangeCount() {
        return this.countBuffer.length;
    }

    private static boolean hasOverlappingRanges(LongRange[] ranges) {
        if (ranges.length == 0) {
            return false;
        }
        LongRange[] sortedRanges = new LongRange[ranges.length];
        System.arraycopy(ranges, 0, sortedRanges, 0, ranges.length);
        Arrays.sort(sortedRanges, Comparator.comparingLong(r -> r.min));
        long previousMax = sortedRanges[0].max;
        for (int i = 1; i < sortedRanges.length; ++i) {
            if (sortedRanges[i].min <= previousMax) {
                return true;
            }
            previousMax = sortedRanges[i].max;
        }
        return false;
    }

    protected static final class InclusiveRange {
        final long start;
        final long end;

        InclusiveRange(long start, long end) {
            assert (end >= start);
            this.start = start;
            this.end = end;
        }

        public String toString() {
            return this.start + " to " + this.end;
        }
    }
}

